package servercore.html5;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import servercore.http.HttpRequest;

public abstract class WebSocketFrame {
	abstract protected void execute(HttpRequest req);
	public enum OP_CODE_TYPE{
		CONTINUATION,
		TEXT,
		BINARY,
		NON_CONTROL,
		CLOSE,
		PING,
		PONG,
		FURTHER_CONTROL
	}
	protected OutputStream ops = null;
	protected InputStream ips = null;

	public void setStream(OutputStream ops, InputStream ips) {
		this.ops = ops;
		this.ips = ips;
	}
	public String read() throws IOException{
		byte[] data = new byte[8098];
		int len = ips.read(data);
/*
		for(int i = 0;i < len;i++) {
			System.out.printf("%2d:%#x\n", i, data[i]);
		}
*/
		if(len < 8) {
			return "";
		}
		boolean isFinalPacket = (data[0] & 0x80) == 0x80;
		int opCode = data[0] & 0x15;
		OP_CODE_TYPE opCodeType = null;
		switch(opCode) {
		case 0x00:
			opCodeType = OP_CODE_TYPE.CONTINUATION;
			break;
		case 0x01:
			opCodeType = OP_CODE_TYPE.TEXT;
			break;
		case 0x02:
			opCodeType = OP_CODE_TYPE.BINARY;
			break;
		case 0x03:
		case 0x04:
		case 0x05:
		case 0x06:
		case 0x07:
			opCodeType = OP_CODE_TYPE.NON_CONTROL;
			break;
		case 0x08:
			opCodeType = OP_CODE_TYPE.CLOSE;
			break;
		case 0x09:
			opCodeType = OP_CODE_TYPE.PING;
			break;
		case 0x0A:
			opCodeType = OP_CODE_TYPE.PONG;
			break;
		case 0x0B:
		case 0x0C:
		case 0x0D:
		case 0x0E:
		case 0x0F:
			opCodeType = OP_CODE_TYPE.FURTHER_CONTROL;
			break;
		default:
			break;
		}
		boolean masked = (data[1] & 0x80) == 0x80;
		byte payloadLength = (byte)(data[1] & 0x7f);
		if(payloadLength == 0x7e) {
			// next Uint16
		} else if(payloadLength == 0x7f) {
			// nexy Uint64
		}
		byte[] maskingKey = new byte[4];
		maskingKey[0] = data[2];
		maskingKey[1] = data[3];
		maskingKey[2] = data[4];
		maskingKey[3] = data[5];
		byte[] appData = new byte[payloadLength];
		for(int i = 0;i < payloadLength;i++) {
			appData[i] = (byte)(data[6 + i] ^ maskingKey[i % 4]);
		}
		return new String(appData);
	}
	public void send(String str) throws IOException {
		if(ops == null) {
			return;
		}
		int payloadLength = str.length();
		ops.write(0x81);
		if(payloadLength < 126) {
			ops.write((byte)payloadLength);
		} else if(payloadLength < 65536) {
			ops.write(0x7e);
			ops.write(payloadLength >> 8 & 0xFF);
			ops.write(payloadLength & 0xFF);
		} else {
			ops.write(0x7F);
			ops.write(0x00);
			ops.write(0x00);
			ops.write(0x00);
			ops.write(0x00);
			ops.write(payloadLength >> 24 & 0xFF);
			ops.write(payloadLength >> 16 & 0xFF);
			ops.write(payloadLength >> 8 & 0xFF);
			ops.write(payloadLength & 0xFF);
		}
		ops.write(str.getBytes());
		ops.flush();
	}
}
